//Experiment-7
// windows Vista - 32-Bit
//Scilab - 5.5.2


// Aim : Finding voltage regulation and efficiency of a long transmission line using Rigorous solution method through SCILAB

mode(0);

clc 
clear all
disp('Rigorous Method for Long transmission line') 
R = input('Enter the Total line Resistance in Ohms : ');  // Total line Resistance in Ohms like 32 Ohms
XL = input('Enter the Total line Inductive Reactance in Ohms : '); // Total line Inductive Reactance in Ohms like 50 Ohms
y = input('Enter the Total line Suseptance in Seimen : '); // Total line Suseptance in Seimen like 0.0003
f = input('Enter the frequency in Hz : '); // frequency in Hz like 50 Hz
PR= input('Enter the Recieving End Power in Watt : ');// Recieving End Power in Watt like 20e6
VRLL= input('Enter the Recieving End Line Voltage in Volt :'); // Recieving End Line Voltage in Volt like 110e3
pf= input('Enter Recievinf End Lagging Power Factor : '); // Recievinf End Lagging Power Factor like 0.8
Z=R+%i*XL;
Y= %i*y;
VR = VRLL/sqrt(3);
IR=PR/(sqrt(3)*VRLL*pf);

A = 1+ (Z*Y)/2 + (Z*Z*Y*Y)/24;    //A= cosh(sqrt(Y*Z))

B = sqrt(Y*Z) + ((Y*Z)^(3/2))/6;    //B = sinh(sqrt(Y*Z))

VS = VR*A + IR*sqrt(Z/Y)*B;    //VS = VR*cosh(sqrt(Y*Z)) + IR*sqrt(Z/Y)*sinh(sqrt(Y*Z))

IS = VR*sqrt(Y/Z)*B + IR*A;   //IS = VR*sqrt(Y/Z)*sinh(sqrt(Y*Z)) + IR*cosh(sqrt(Y*Z))

[VS_abs,Phase_VS]= polar(VS);
[IS_abs,Phase_IS]= polar(IS);
VS_abs;
IS_abs;
VSLL=VS*sqrt(3);
VSLL_abs=abs(VSLL)/1000;
Phase_VS;
Phase_IS;

PHASE_DIFF=Phase_VS-Phase_IS;

SendingEnd_PF=cos(PHASE_DIFF);

PS=3*VS_abs*IS_abs*cos(PHASE_DIFF);
EFF=(abs(PR)/abs(PS))*100;
REG = 100*((abs (VSLL) - abs (VRLL)))/ abs (VRLL);

mprintf('\n\nSendingend Current = %f A \n',IS_abs)
mprintf('Sendingend Line Voltage = %f kV \n',VSLL_abs)
mprintf('Sendingend Power factor = %f \n',SendingEnd_PF)
mprintf('Efficiency = %f %% \n', EFF)
mprintf('Regulation = %f %% \n', REG)


//output:-
//
// Rigorous Method for Long transmission line   
//Enter the Total line Resistance in Ohms : 32
//Enter the Total line Inductive Reactance in Ohms : 50
//Enter the Total line Suseptance in Seimen : 0.0003
//Enter the frequency in Hz : 50
//Enter the Recieving End Power in Watt : 20e6
//Enter the Recieving End Line Voltage in Volt :110e3
//Enter Recievinf End Lagging Power Factor : 0.8
//
//
//Sendingend Current = 131.674018 A 
//Sendingend Line Voltage = 117.015932 kV 
//Sendingend Power factor = 0.998847 
//Efficiency = 75.028310 % 
//Regulation = 6.378120 % 
